#pragma once

#include "playercore/platform/ps4/VideoFrame.hpp"
#include "VideoSample.hpp"
#include <memory>
#include <videodec2.h>

namespace twitch {
namespace ps4 {
    class VideoFrameBuffer;
    struct VideoSample;

    class VideoFrame : public twitch::VideoFrame {
    public:
        class Listener {
        public:
            virtual void onFrameRendered(const VideoFrame& frame) = 0;
            virtual void onFrameNeedsReleasing(std::shared_ptr<VideoFrame>& videoFrame) = 0;
        };

        VideoFrame(Listener& listener, const std::shared_ptr<const VideoSample>& sample);
        virtual ~VideoFrame();

        const SceVideodec2OutputInfo& getOutputInfo() const override;
        const SceVideodec2AvcPictureInfo& getPictureInfo() const override;
        bool isFinished() const;
        void finish() override;
        void flush();

        const MediaTime& getPresentationTime() const { return m_sample->getPresentationTime(); }
        const MediaTime& getDuration() const { return m_sample->getDuration(); }
        const VideoSample& getSample() const { return *m_sample; }
        const MediaTime& getRenderStartTime() const { return m_renderStartTime; }
        void setRenderStartTime(MediaTime time) { m_renderStartTime = time; }

    private:
        Listener& m_listener;
        std::shared_ptr<const VideoSample> m_sample;
        bool m_finished = false;
        MediaTime m_renderStartTime;
    };
}
}
