#pragma once

#include "FrameBufferPool.hpp"
#include "abr/MovingAverage.hpp"
#include "util/Concurrency.hpp"
#include "playercore/platform/ps4/VideoFrame.hpp"
#include "playercore/referenceclock.hpp"
#include "playercore/MediaRenderer.hpp"
#include "VideoFrame.hpp"
#include <deque>
#include <memory>

namespace twitch {
namespace ps4 {
    class VideoFrame;
    struct VideoSample;

    class VideoFrameBuffer : public twitch::VideoFrameBuffer,
                             public VideoFrame::Listener {
    public:
        class Listener {
        public:
            virtual void onFrameRendered(const MediaTime& presentationTime) = 0;
            virtual void onFrameNeedsReleasing(std::shared_ptr<VideoFrame>& videoFrame) = 0;
            virtual void onDroppedFrame() = 0;
        };

        VideoFrameBuffer(Listener& listener, const ReferenceClock& clock, int frameBufferCount);
        virtual ~VideoFrameBuffer() = default;

        void addFrame(const std::shared_ptr<const VideoSample>& sample);
        void flush();
        std::shared_ptr<twitch::VideoFrame> getFrame() override;
        void start();
        void stop();

    protected:
        void onFrameRendered(const VideoFrame& frame) override;
        void onFrameNeedsReleasing(std::shared_ptr<VideoFrame>& videoFrame) override;

        Listener& m_listener;
        const ReferenceClock& m_clock;
        Mutex m_mutex;
        ConditionVariable m_condition;
        std::deque<std::shared_ptr<VideoFrame>> m_frames;
        // Make sure our buffer size is smaller than the buffer pool's
        size_t m_maxFramesSize;
        std::shared_ptr<ps4::VideoFrame> m_current;

        // Calculate time to render to estimate next PTS to render
        MovingAverage<uint64_t> m_timeToRender;

        MediaTime m_overrideSeekTime;
    };
}
}
