#pragma once

#include "playercore/platform/ps4/PlayerCore.hpp"
#include "playercore/referenceclock.hpp"
#include "playercore/platform/VideoRenderer.hpp"
#include "VideoFrameBuffer.hpp"
#include <atomic>

namespace twitch {
namespace ps4 {
    class VideoFrameBuffer;
    class OnFrameNeedsReleasing;

    class VideoRenderer : public twitch::VideoRenderer,
                          public VideoFrameBuffer::Listener {
    public:
        VideoRenderer(PlayerCore::OnVideoFrameBuffer onVideoFrameBuffer, PlayerCore::OnFrameNeedsReleasing onFrameNeedsReleasing, const ReferenceClock& clock, int frameBufferCount);
        virtual ~VideoRenderer();
        MediaResult configure(const MediaFormat& format) override;
        MediaResult render(std::shared_ptr<const MediaSample> input) override;
        MediaResult getDroppedFrames(int& count) override;
        MediaResult getRenderedFrames(int& count) override;
        MediaResult getRenderedPresentationTime(MediaTime& time) override;
        MediaResult flush() override;
        MediaResult start() override;
        MediaResult stop() override;
        MediaResult setPlaybackRate(float rate) override;

    protected:
    private:
        void dumpAvcInformation(const SceVideodec2AvcPictureInfo& avcPicInfo, int decodeCount) const;
        static float getAvcFrameRate(const SceVideodec2AvcPictureInfo& pPicInfo);
        void onFrameRendered(const MediaTime& presentationTime) override;
        void onFrameNeedsReleasing(std::shared_ptr<VideoFrame>& videoFrame) override;
        void onDroppedFrame() override;

        std::shared_ptr<VideoFrameBuffer> m_frameBuffer;
        PlayerCore::OnFrameNeedsReleasing m_onFrameNeedsReleasing;

        MediaTime m_lastPresentationTime;

        std::atomic<int> m_droppedFrames{ 0 };
        std::atomic<int> m_renderedFrames{ 0 };
    };
}
}
