#include "VideoSample.hpp"
#include "debug/trace.hpp"
#include <cassert>

using namespace twitch;
using namespace ps4;

VideoSample::VideoSample(const SceVideodec2OutputInfo& outputInfo)
    : outputInfo(outputInfo)
{
    pictures[0].thisSize = pictures[1].thisSize = sizeof(pictures[0]);

    int retVal = 0;

    if (1 == outputInfo.pictureCount) {
        retVal = sceVideodec2GetPictureInfo(&outputInfo, &pictures[0], nullptr);
    } else if (2 == outputInfo.pictureCount) {
        TRACE_DEBUG("pictureCount:%d there are two output field pictures. Only first one will be used",
            outputInfo.pictureCount);
        retVal = sceVideodec2GetPictureInfo(&outputInfo, &pictures[0], &pictures[1]);
    } else {
        TRACE_WARN("Unexpected pictureCount:%d - Only first picture will be used", outputInfo.pictureCount);
    }

    if (retVal) {
        TRACE_WARN("sceVideodec2GetPictureInfo:0x%08x failed.", retVal);
    }
}

const SceVideodec2AvcPictureInfo& VideoSample::getPicture(int index) const
{
    assert(index == 0 || index == 1);

    // fail-safe in case of bad index
    if (index == 0 || outputInfo.pictureCount <= 1) {
        return pictures[0];
    } else {
        return pictures[1];
    }
}

