#pragma once

#include "playercore/MediaSample.hpp"
#include <videodec2.h>
#include <memory>

namespace twitch {
namespace ps4 {
    struct MediaFrameBufferInfo;

    struct VideoSample : public MediaSample {
        VideoSample(const SceVideodec2OutputInfo& outputInfo);

        const SceVideodec2AvcPictureInfo& getPicture(int index) const;
        const MediaTime& getPresentationTime() const { return mediaSample.presentationTime; }
        const MediaTime& getDuration() const { return mediaSample.duration; }
        int numPictures() const { return outputInfo.pictureCount; }

        size_t id = 0;

        MediaSample mediaSample;
        std::shared_ptr<MediaFrameBufferInfo> frameBuffer;

        // Decoder Info
        SceVideodec2AvcPictureInfo pictures[2];
        SceVideodec2OutputInfo outputInfo;
    };
}
}
