#pragma once

#include "CoInitialize.hpp"
#include "playercore/MediaRenderer.hpp"
#include "XAudioBuffer.hpp"
#include "XAudioMonitor.hpp"
#include "XSourceVoice.hpp"

namespace twitch {
namespace uwp {

    class XMasterVoice;

    class AudioRenderer : public windows::CCoInitialize, public twitch::AudioRenderer {
    public:
        static std::unique_ptr<AudioRenderer> create();

        enum class State {
            Stopped,
            Started,
        };

        AudioRenderer(Microsoft::WRL::ComPtr<IXAudio2> xaudio2, std::shared_ptr<XMasterVoice> masterVoice);
        ~AudioRenderer();

        MediaResult configure(const MediaFormat& format) override;
        MediaResult render(std::shared_ptr<const twitch::MediaSample> input) override;
        MediaResult getRenderedPresentationTime(MediaTime& time) override;

        MediaResult start() override;
        MediaResult stop() override;
        MediaResult flush() override;

        MediaResult setPlaybackRate(float rate) override;
        MediaResult setVolume(float volume) override;

        friend class XSourceVoice;

    private:
        // XAudio2 resources
        Microsoft::WRL::ComPtr<IXAudio2> m_xAudio2;
        std::shared_ptr<XMasterVoice> m_masterVoice;
        XSourceVoice m_sourceVoice;

        std::unique_ptr<XAudioMonitor> m_monitor;

        WORD m_numChannels = 0;
        int m_samplesPerSecond = 0;
        WORD m_bitsPerSample = 0;

        std::chrono::time_point<std::chrono::system_clock> m_startTime;

        // State of the renderer
        State m_state = State::Stopped;

        std::thread::id m_threadId;
    };
}
}
