#pragma once

#include "playercore/platform/HttpClient.hpp"
#include "httptimer.hpp"

namespace twitch {
namespace uwp {

    class HttpRequest;

    class HttpClient : public twitch::HttpClient {
    public:
        HttpClient();
        ~HttpClient() override = default;

        std::shared_ptr<twitch::HttpRequest> createRequest(const std::string& url, twitch::HttpMethod method /* = HttpMethod::GET */) override;

        void send(std::shared_ptr<twitch::HttpRequest> request, ResponseHandler onResponse, ErrorHandler onError) override;

    private:
        Windows::Web::Http::HttpClient ^ m_client;
    };

    class HttpResponse : public twitch::HttpResponse, public std::enable_shared_from_this<HttpResponse> {
    public:
        HttpResponse(Windows::Web::Http::HttpResponseMessage ^ responseMessage, int syncPoint);
        ~HttpResponse() override;

        std::string getHeader(const std::string& key) const override;
        void read(ContentHandler onBuffer, ErrorHandler onError) override;

    private:
        void cancel();
        void onCancel();

        class StreamReader : public std::enable_shared_from_this<StreamReader> {
        public:
            StreamReader(ContentHandler contentHandler, concurrency::cancellation_token token);

            concurrency::task<Windows::Storage::Streams::IBuffer^> read(
                Windows::Storage::Streams::IInputStream^ stream,
                std::shared_ptr<windows::HttpTimer> timer
            );

        private:
            ContentHandler m_contentHandler;
            concurrency::cancellation_token m_token;
            Windows::Storage::Streams::Buffer^ m_buffer;
        };

    private:
        concurrency::cancellation_token_source m_cts;
        concurrency::cancellation_token_registration m_cancelCallback;
        std::shared_ptr<windows::HttpTimer> m_timer;
        int m_syncPoint;

        Windows::Web::Http::HttpResponseMessage ^ m_responseMessage;
    };

}
}
