#pragma once

#include "playercore/platform/HttpRequest.hpp"
#include "HttpClient.hpp"

namespace twitch {
namespace uwp {
    class HttpRequest : public twitch::HttpRequest, public std::enable_shared_from_this<HttpRequest> {
    public:
        HttpRequest(Windows::Web::Http::HttpClient ^ client, const std::string& url, twitch::HttpMethod method = HttpMethod::GET);
        ~HttpRequest() override;

        void send(HttpClient::ResponseHandler onResponse, HttpClient::ErrorHandler onError);

        void setHeader(const std::string& key, const std::string& value) override;
        void setContent(const std::vector<uint8_t>& content) override;
    private:
        void cancel() override;
        void onCancel();

        Windows::Web::Http::HttpRequestMessage^ createMessage();

    private:
        concurrency::cancellation_token_source m_cts;
        concurrency::cancellation_token_registration m_cancelCallback;
        std::shared_ptr<windows::HttpTimer> m_timer;

        Windows::Web::Http::HttpClient ^ m_client;

        twitch::HttpHeaderMap m_headers;
        std::condition_variable m_cancelCondition;
        static const int MaxSyncPoints = 18;
        int m_syncPoint;
    };
}
}
