#include "pch.h"

#include "XAudioBuffer.hpp"

#include "debug/trace.hpp"
#include "XSourceVoice.hpp"

using namespace twitch;
using namespace uwp;

using namespace Microsoft;
using namespace Microsoft::WRL;

XAudioBuffer::XAudioBuffer(const windows::AudioSample& audioSample)
    : m_sample(audioSample)
{
    m_buffer.Flags = 0;
    m_buffer.AudioBytes = static_cast<UINT32>(m_sample.buffer.size());
    assert(m_buffer.AudioBytes <= XAUDIO2_MAX_BUFFER_BYTES);

    m_buffer.pAudioData = m_sample.buffer.data();
    m_buffer.PlayBegin = 0;
    m_buffer.PlayLength = 0;
    m_buffer.LoopBegin = 0;
    m_buffer.LoopLength = 0;
    m_buffer.LoopCount = 0;
    m_buffer.pContext = this;
}

void XAudioBuffer::onBufferStart()
{
    assert(m_state == State::UNRENDERED);
    m_state = State::STARTED;
}

void XAudioBuffer::onBufferEnd()
{
    if (m_state == State::STARTED) {
        m_state = State::RENDERED;
    }
}

void XAudioBuffer::onFlush()
{
    m_state = State::FLUSHED;
}
