#pragma once

#include "AudioSample.hpp"

namespace twitch {
namespace uwp {
    // Wrapper class over the XAUDIO2_BUFFER structure. Also manage sound data life-cycle.
    class XAudioBuffer {
    public:
        XAudioBuffer(const windows::AudioSample& audioSample);

        const windows::AudioSample& getSample() const { return m_sample; }
        const XAUDIO2_BUFFER& getBuffer() const { return m_buffer; }

        bool hasRendered() const { return m_state == State::RENDERED; }

        void onBufferStart();
        void onBufferEnd();
        void onFlush();

    private:
        const windows::AudioSample m_sample;
        XAUDIO2_BUFFER m_buffer;

        enum class State {
            UNRENDERED,
            STARTED,
            FLUSHED,
            RENDERED
        } m_state = State::UNRENDERED;
    };
}
}
