#pragma once

#include "CoInitialize.hpp"
#include "playercore/MediaSample.hpp"

namespace twitch {
namespace uwp {
    // Asynchronously monitor the state of the XAudio2 subsystem
    class XAudioMonitor : public windows::CCoInitialize {
    public:
        XAudioMonitor(Microsoft::WRL::ComPtr<IXAudio2>& xAudio2);

        void print();
        void update(const twitch::MediaSample& input);

    private:
        Microsoft::WRL::ComPtr<IXAudio2> m_xAudio2;

        /**
         * Timer class that fires an event (onTick()) after a given period of
         * time has elapsed
         *
         * This class relies on its time to be manually updated (via update()),
         * since it doesn't require a background thread
         */
        class Timer {
        public:
            std::function<void()> onTick;

            Timer(std::chrono::seconds period = std::chrono::seconds(2));

            void update(MediaTime time);

        private:
            const std::chrono::seconds m_period;
            MediaTime m_start = MediaTime::zero();
            size_t m_numTicks = 0;
        };

        Timer m_timer;
    };
}
}
