#include "pch.h"
#include "XMasterVoice.hpp"
#include "playercore/platform/windows/WindowsPlatform.hpp"

using namespace twitch;
using namespace twitch::uwp;

using namespace Microsoft;
using namespace Microsoft::WRL;

std::shared_ptr<XMasterVoice> XMasterVoice::create(Microsoft::WRL::ComPtr<IXAudio2> xAudio2)
{
    IXAudio2MasteringVoice* masterVoice;
    HRESULT hr = xAudio2->CreateMasteringVoice(&masterVoice);
    if (FAILED(hr)) {
        WindowsPlatform::hError("XAudio2::CreateMasteringVoice", hr);
        assert(false);
        return nullptr;
    }

    return std::make_shared<XMasterVoice>(masterVoice);
}

XMasterVoice::XMasterVoice(IXAudio2MasteringVoice* masterVoice)
    : m_masterVoice(masterVoice)
{
}

XMasterVoice::~XMasterVoice()
{
    if (m_masterVoice) {
        m_masterVoice->DestroyVoice();
        m_masterVoice = nullptr;
    }
}
