#pragma once

#include "semaphore.hpp"

namespace twitch {
namespace uwp {
    class XAudioBuffer;

    // Wrapper over IXAudio2SourceVoice, handle life-cycle as well
    class XSourceVoice : public IXAudio2VoiceCallback {
    public:
        XSourceVoice();
        XSourceVoice(IXAudio2SourceVoice* sourceVoice);
        ~XSourceVoice();

        XSourceVoice(const XSourceVoice& rhs) = delete;
        XSourceVoice& operator=(const XSourceVoice& rhs) = delete;

        HRESULT configure(Microsoft::WRL::ComPtr<IXAudio2> xaudio2, WAVEFORMATEX wfx);
        bool getRenderedPresentationTime(MediaTime& time);
        HRESULT flush();
        HRESULT start();
        HRESULT stop();
        HRESULT submit(const windows::AudioSample& audioSample);

        void setVolume(float volume);
        void garbageCollectBuffers();

        void setPlaybackRate(float rate);

    protected:
        // IXAudio2VoiceCallback overrides
        void __stdcall OnBufferStart(void* pBufferContext) override;
        void __stdcall OnBufferEnd(void* pBufferContext) override;
        void __stdcall OnLoopEnd(void* /*pBufferContext*/) override {}
        void __stdcall OnStreamEnd() override {}
        void __stdcall OnVoiceError(void* /*pBufferContext*/, HRESULT /*Error*/) override;
        void __stdcall OnVoiceProcessingPassEnd() override {}
        void __stdcall OnVoiceProcessingPassStart(UINT32 /*bytesRequired*/) override {}

    private:
        void release();
        void ensureSameThread() const;

        // Currently active voice buffers
        std::unordered_set<const XAudioBuffer*> m_xBuffers;

        // Voice buffers queued to be removed
        std::unordered_set<const XAudioBuffer*> m_toRemove;
        std::mutex m_mutex; // to protect concurrent access m_toRemove

        IXAudio2SourceVoice* m_sourceVoice;

        std::atomic<MediaTime> m_lastRenderedTime = MediaTime::invalid();

        // semaphore prevents queuing too many audio samples
        windows::Semaphore m_semaphore;

        std::thread::id m_threadId;

        float m_setPlaybackRate = 1.0f;
    };
}
}
