player-core-web
===========================

## Latest build
* [develop](http://cvp-web.twitch.tv/origin/develop)

## Installation instructions (OSX)

Install Xcode Command Line Tools: `xcode-select --install`

Install [homebrew](http://brew.sh/): `/usr/bin/ruby -e "$(curl -fsSL https://raw.githubusercontent.com/Homebrew/install/master/install)"`

The only dependency is [empscripten](https://github.com/kripken/emscripten) (and `re2c` for libcaption). You can install it with [homebrew](brew.sh). You must also set the `LLVM` environment variable to the llvm exectuable installed with emscripten. I recomend you do this in your `.bash_profile`.

Note - Emscripten versions from 1.38.34 through 1.38.38 are currently not workable with our webpack configuration. Please ensure the emscripten version is prior to 1.38.34. Try the following command first 
```
brew info emscripten
```

Follow the instructions below only if the homebrew version is > 1.38.38

* `brew update && brew install emscripten re2c cmake`
* Add/replace this in your emscripten config file `~/.emscripten` (if you installed everything with default settings): 
```
EMSCRIPTEN_ROOT = '/usr/local/opt/emscripten/libexec'
LLVM_ROOT = '/usr/local/opt/emscripten/libexec/llvm/bin'
```
* Add this to your `.bash_profile`: 
```
export LLVM="`brew --prefix`/opt/emscripten/libexec/llvm/bin"
```
#### Use EMSDK to install specific versions of emscripten. 
* Make sure you uninstall the homebrew version if you have one. `brew uninstall emscripten`
* Visit https://emscripten.org/docs/getting_started/downloads.html and install latest 
* Use `./emsdk list` command to see the list of tools versions available to install
* Install the specific version. Ex: `./emsdk install 1.38.33`
* Activate the version Ex: `./emsdk activate 1.38.33`
* Run the emsdk_env.sh shell script to have the paths setup. `source ./emsdk_env.sh`
* Add the command above to your `~/.bash_profile` file to avoid having to do it everytime. Make sure the path of `emsdk_env.sh` is correct

## Installation instructions (Windows)

* Install Binary CMake from: https://cmake.org/download/
  * Add CMake binary to your path (ex: C:\cmake\bin)
* Install Binary re2c from: http://re2c.org/install/install.html
  * Alternatively, you may compile it yourself for Windows from: https://github.com/skvadrik/re2c
  * Add re2c binary to your path (ex: C:\re2c\bin)

## How to run javascript development player

You first need to add a `*.twitch.tv` alias to your `/etc/hosts` file to prevent CORS issues. For example, you can add this line: `127.0.0.1   localhost.twitch.tv`. Then do the following

* `npm install` (only needed the first time, or when we update dependencies)
* `npm start` (starts the webpack-dev-server)
* open [http://localhost.twitch.tv:8080/](http://localhost.twitch.tv:8080/)

## Creating and deploying a release
1. Bump version number in `package.json` to desired version and make a release branch from that commit (ie. “release/1.2.3-web”). If releasing from master branch, can just apply version bump commit onto master. If a hotfix on a previous release, check that release out, apply changes, then bump version number. We generally title the release commit as “Release 1.2.3”
2. Push branch and wait for build to succeed.
3. Go to https://teamcity.internal.justin.tv/viewType.html?buildTypeId=PlayerCore_Release_Web_All_ReleaseWebCustomer. Select the release branch under the `<All branches>` dropdown. Then click `Run` in the top right (don't click the `...`).
4. Once deploy succeeds, go to http://player.twitch.tv/?channel=bufferbunny&cvp-ver=1.2.3 with the appropriate version number. Check that it loads correctly.
5. Open a PR on player-ui to update `DEFAULT_MEDIAPLAYER_VERSION` in [experiments.js](https://git-aws.internal.justin.tv/video/player-ui/blob/develop/src/js/experiments.js#L71) to the latest player-core version. Automated tests rely on this version to determine which Player Core version to use.
6. Open a PR on twilight to update `default` versions of player-core in [experiments.ts](https://git-aws.internal.justin.tv/twilight/twilight/blob/master/src/core/constants/experiments.ts#L232-L239) to the latest player-core version. Automated tests rely on this version to determine which Player Core version to use.

## NEW - Twilight player-core npm release
1. Make sure the "Creating and deploying a release" step is done
2. Go to [Twilight repo](https://git-aws.internal.justin.tv/twilight/twilight)
3. Checkout master branch
4. Create a branch "update_player_core_vx.y.z_staff" or "update_player_core_vx.y.z_user"
5. Player core has 3 variants of player-core : base, variant-a, variant-b
6. Choose the variant which should be a particular version
7. Update the package.json and run `yarn` so that yarn.lock file updates
8. Commit the change with message "Updating player-core-variant-x to version vx.y.z for staff/user"
9. Push the branch to twilight and create a PR against master
10. Drop the PR link to slack channel #player-browser-collab and request for reviews
11. Wait for PR to be merged
12. Update the appropriate experiment to desired percentages
     * [Staff Experiment](https://minixperiment.di.xarth.tv/admin#/experiment/7be6e176-3c3e-46a3-ab50-abd8dc73da1e)
     * [User Experiment](https://minixperiment.di.xarth.tv/admin#/experiment/7ff6a29e-5681-45ed-ad66-46d35a9549bc)

## Rolling it out
1. Cross post release to the #ATC slack channel to notify other teams (Use the 'xpost' slack comman).
2. Go to our minixperiment selector for media player version https://minixperiment.di.xarth.tv/admin#/experiment/ec70bd08-dbc8-4f48-9f60-d035fec3eb20. Start rollout by giving version to staff (a separate experiment on that page. Search for “staff”) and 5% of users for a day. If that looks good the next day,  we'll bump to 20% and wait an additional day. If that looks good, we go to 100%
3. Monitor release on Graphana (https://grafana.internal.justin.tv/d/000001671/player-core-web-dash?panelId=9&fullscreen&orgId=1). Usually look at the BE/MW by version to see if something looks very wrong.
4. Use mode to analyze data. We usually use the “Web QoS” queries at the bottom of this report https://modeanalytics.com/editor/twitch/reports/92553bae64f6. Be sure to start query ~3-4 hours after changing the version to give users a chance to “settle”.

### How to roll back
1. Every version pushed is archived with a `[major|minor|patch]`.
2. Use the minixperiment [dashboard](https://minixperiment.prod.us-west2.justin.tv/admin#/) to remove any version which is problematic.
