import {
    AccessTokenConfig,
    createMasterPlaylistUrl,
    getAccessToken,
    TokenResponse,
} from './accesstoken';

describe('Access token request and master playlist url', () => {
    const prevXHR = global['XMLHttpRequest'];

    afterAll(() => {
        global['XMLHttpRequest'] = prevXHR;
    });

    test('live', (done) => {
        const streamId = 'bobross';
        const streamType = 'channel';
        const clientId = '7xowrgquc8495rq4w5p79aeiwzxglu8';
        const oAuthToken = 'avlv29cj7kpikr4go6v7k78apvcgf5';
        const playerType = 'site';
        const playerBackend = 'mediaplayer';
        const platform = 'web';
        const sig = '6bf3134cedcfb3dfc46a18f4dc615882d32b19c1';
        const token = '{"adblock":true,"authorization":{"forbidden":false,"reason":""},"blackout_enabled":false,"channel":"bobross","channel_id":105458682,"chansub":{"restricted_bitrates":[],"view_until":1924905600},"ci_gb":false,"geoblock_reason":"","device_id":"TKyHSukmfPI46OLdnQI9HCxkr7Ia1cf0","expires":1555698943,"game":"Art","hide_ads":true,"https_required":true,"mature":false,"partner":false,"platform":"web","player_type":"site","private":{"allowed_to_view":true},"privileged":false,"server_ads":true,"show_ads":false,"subscriber":false,"turbo":true,"user_id":66239750,"user_ip":"64.125.35.114","version":2}';

        const config: AccessTokenConfig = {
            streamId,
            streamType,
            clientId,
            oAuthToken,
            playerType,
            playerBackend,
            platform,
        };

        const xhrMock = {
            open: jest.fn((method: string, path: string) => {
                const url = new URL(path);
                expect(url.origin).toEqual('https://api.twitch.tv');
                expect(url.pathname).toEqual(`/api/channels/${streamId}/access_token`);
                expect(url.searchParams.get('client_id')).toEqual(clientId);
                expect(url.searchParams.get('oauth_token')).toEqual(oAuthToken);
                expect(url.searchParams.get('player_type')).toEqual(playerType);
                expect(url.searchParams.get('player_backend')).toEqual(playerBackend);
                expect(url.searchParams.get('platform')).toEqual(platform);
            }),
            send: jest.fn(),
            onload: () => done.fail('No onload listener'),
            status: 200,
            responseText: JSON.stringify({ token, sig }),
        };

        global['XMLHttpRequest'] = jest.fn(() => xhrMock);

        getAccessToken(config).then((resp: TokenResponse) => {
            const url = new URL(createMasterPlaylistUrl(config, resp));
            expect(url.origin).toEqual('https://usher.ttvnw.net');
            expect(url.pathname).toEqual(`/api/channel/hls/${streamId}.m3u8`);
            expect(url.searchParams.get('token')).toEqual((token));
            expect(url.searchParams.get('sig')).toEqual(sig);
        }).then(done, done);

        xhrMock.onload();
    });

    test('vod', (done) => {
        const streamId = '413749414';
        const streamType = 'vod';
        const clientId = '7xowrgquc8495r6k2vb79aeiwzxglu8';
        const oAuthToken = 'j5ndhfcj7kpikr4go6v7k78apvcgf5';
        const playerType = 'pulsar';
        const playerBackend = 'mediaplayer';
        const platform = 'web';
        const sig = 'fc298b4a7e449468236e83913ee2a3d7b6857f8e';
        const token = '{"authorization":{"forbidden":false,"reason":""},"chansub":{"restricted_bitrates":[]},"device_id":null,"expires":1556126242,"https_required":false,"privileged":false,"user_id":null,"version":2,"vod_id":413749414}';

        const config: AccessTokenConfig = {
            streamId,
            streamType,
            playerBackend,
            clientId,
            oAuthToken,
            playerType,
            platform,
        };

        const xhrMock = {
            open: jest.fn((method: string, path: string) => {
                const url = new URL(path);
                expect(url.origin).toEqual('https://api.twitch.tv');
                expect(url.pathname).toEqual(`/api/vods/${streamId}/access_token`);
                expect(url.searchParams.get('client_id')).toEqual(clientId);
                expect(url.searchParams.get('oauth_token')).toEqual(oAuthToken);
                expect(url.searchParams.get('player_type')).toEqual(playerType);
                expect(url.searchParams.get('player_backend')).toEqual(playerBackend);
                expect(url.searchParams.get('platform')).toEqual(platform);
            }),
            send: jest.fn(),
            onload: () => done.fail('No onload listener'),
            status: 200,
            responseText: JSON.stringify({ token, sig }),
        };

        global['XMLHttpRequest'] = jest.fn(() => xhrMock);

        getAccessToken(config).then((resp: TokenResponse) => {
            const url = new URL(createMasterPlaylistUrl(config, resp));
            expect(url.origin).toEqual('https://usher.ttvnw.net');
            expect(url.pathname).toEqual(`/vod/${streamId}.m3u8`);
            expect(url.searchParams.get('nauth')).toEqual((token));
            expect(url.searchParams.get('nauthsig')).toEqual(sig);
        }).then(done, done);

        xhrMock.onload();
    });
});
