import * as Bowser from 'bowser';
import { BrowserContext } from './web-mediaplayer';

const FULL_SEMVER_REGEX = /^(\d+)\.(\d+)\.(\d+)[+|-]?(.*)?$/;
const MAJOR_MINOR_VERSION_REGEX = /^(\d+)\.(\d+)[+|-]?(.*)?$/;
const ANY_DIGIT_REGEX = /^(\d+)$/;

const detected = Bowser._detect(navigator.userAgent);
const parsedVersion = parseSemver(String(detected.version));

export const browser: BrowserContext = {
    chrome: detected.chrome,
    chromecast: navigator.userAgent.toLowerCase().indexOf('crkey') > -1,
    domain: window.location.host.split('.').slice(-2).join('.'),
    family: detected.name.toLowerCase(), // normalize to lowercase
    firefox: detected.firefox,
    host: window.location.host,
    major: parsedVersion.major,
    minor: parsedVersion.minor,
    msedge: detected.msedge,
    msie: detected.msie,
    name: navigator.appVersion,
    opera: detected.opera,
    osName: detected.osname,
    osVersion: String(detected.osversion),
    patch: parsedVersion.patch,
    safari: detected.safari,
    url: window.location.href,
    userAgent: navigator.userAgent,
};

interface SemverObject {
    major: number;
    minor: number;
    patch: number;
}

function parseSemver(str: string): SemverObject {
    const arr =
        FULL_SEMVER_REGEX.exec(str) ||
        MAJOR_MINOR_VERSION_REGEX.exec(str) ||
        ANY_DIGIT_REGEX.exec(str) ||
        [];

    return {
        major: parseInt(arr[1], 10) || 0,
        minor: parseInt(arr[2], 10) || 0,
        patch: parseInt(arr[3], 10) || 0,
    };
}
