function getBody(xmlDoc: Document) {
    let licenseRequest = null;
    if (xmlDoc.getElementsByTagName('Challenge').length > 0 && xmlDoc.getElementsByTagName('Challenge')[0]) {
        const Challenge = xmlDoc.getElementsByTagName('Challenge')[0].childNodes[0].nodeValue;
        if (Challenge) {
            licenseRequest = atob(Challenge);
        }
    }
    return licenseRequest;
}

function getHeaders(xmlDoc: Document) {
    const headers = {};
    const headerNameList = xmlDoc.getElementsByTagName('name');
    const headerValueList = xmlDoc.getElementsByTagName('value');
    for (let i = 0; i < headerNameList.length; i++) {
        headers[headerNameList[i].childNodes[0].nodeValue] = headerValueList[i].childNodes[0].nodeValue;
    }
    return headers;
}

/**
 * PlayReady License Request requires transforming the ArrayBuffer into XML format
 * and adding headers included inside the message created by CDM
 * Based on Window's Docs/Dash implementation: https://docs.microsoft.com/en-us/previous-versions/windows/apps/dn457474(v%3dieb.10)
 * @param {ArrayBuffer} message - https://www.w3.org/TR/2014/WD-encrypted-media-20140828/encrypted-media.html#dom-mediakeymessageevent
 */
export function licenseRequestData(message) {
    const msg = String.fromCharCode.apply(null, new Uint16Array(message));
    const xmlDoc = new DOMParser().parseFromString(msg, 'application/xml');
    return {
        headers: getHeaders(xmlDoc),
        body: getBody(xmlDoc),
    };
}
