/**
 * Note:
 * There may need to be multiple uuids, I have seen there
 * are two uuids for clearkey, but have only seen this one
 * used on our content.
 */
export interface KeySystem {
    keySystem: string;
    uuid: string;
    certUrl?: string;
    licenseUrl?: string;
}

export interface CDMError {
    value: number;
    code?: number;
    message: string;
}

const CLEARKEY: KeySystem = {
    keySystem: 'org.w3.clearkey',
    uuid: '1077efec-c0b2-4d02-ace3-3c1e52e2fb4b',
};

const FAIRPLAY: KeySystem = {
    keySystem: 'com.apple.fps.2_0',
    certUrl: 'https://fp-keyos-twitch.licensekeyserver.com/cert/a17fd33d3843df9b17679ccf50a419b2.der',
    licenseUrl: 'https://fp-keyos-twitch.licensekeyserver.com/getkey',
    uuid: '94CE86FB-07FF-4F43-ADB8-93D2FA968CA2',
};

const PLAYREADY: KeySystem = {
    keySystem: 'com.microsoft.playready',
    licenseUrl: 'https://pr-keyos-twitch.licensekeyserver.com/core/rightsmanager.asmx',
    uuid: '9a04f079-9840-4286-ab92-e65be0885f95',
};

const WIDEVINE: KeySystem = {
    keySystem: 'com.widevine.alpha',
    licenseUrl: 'https://wv-keyos-twitch.licensekeyserver.com',
    uuid: 'edef8ba9-79d6-4ace-a3c8-27dcd51d21ed',
};

export const KEY_SYSTEMS = {
    CLEARKEY,
    FAIRPLAY,
    PLAYREADY,
    WIDEVINE,
};

export const KEY_SYSTEMS_BY_STRING = {
    'com.widevine.alpha': WIDEVINE,
    'com.microsoft.playready': PLAYREADY,
    'com.apple.fps.2_0': FAIRPLAY,
    'org.w3.clearkey': CLEARKEY,
};

export const AUTH_XML_URL = 'https://vizima.twitch.tv/api/authxml/';

const NETWORK_ERROR_VALUE = 2;
const NOT_SUPPORTED_ERROR_VALUE = 4;

const NO_CDM_SUPPORT_ERROR: CDMError = {
    value: NOT_SUPPORTED_ERROR_VALUE,
    message: 'Your browser does not support any DRM Content Decryption Modules',
};

const SESSION_UPDATE_ERROR: CDMError = {
    value: NOT_SUPPORTED_ERROR_VALUE,
    message: 'There was an issue while updating DRM License',
};

const LICENSE_REQUEST_ERROR: CDMError = {
    value: NETWORK_ERROR_VALUE,
    message: 'Error while requesting DRM license',
};

const KEY_SESSION_CREATION_ERROR: CDMError = {
    value: NOT_SUPPORTED_ERROR_VALUE,
    message: 'Error creating key session',
};

const KEY_SESSION_INTERNAL_ERROR: CDMError = {
    value: NOT_SUPPORTED_ERROR_VALUE,
    message: 'Encryption key not usable because of internal error in CDM',
};

const NO_PSSH_FOUND_ERROR: CDMError = {
    value: NOT_SUPPORTED_ERROR_VALUE,
    message: 'Unable to find valid CDM support on media',
};

const AUTH_XML_REQUEST_ERROR: CDMError = {
    value: NETWORK_ERROR_VALUE,
    message: 'Request for AuthXML failed',
};

const CERT_REQUEST_ERROR: CDMError = {
    value: NETWORK_ERROR_VALUE,
    message: 'Request for DRM certificate failed',
};

export const ERRORS = {
    NO_CDM_SUPPORT: NO_CDM_SUPPORT_ERROR,
    SESSION_UPDATE: SESSION_UPDATE_ERROR,
    LICENSE_REQUEST: LICENSE_REQUEST_ERROR,
    KEY_SESSION_CREATION: KEY_SESSION_CREATION_ERROR,
    KEY_SESSION_INTERNAL: KEY_SESSION_INTERNAL_ERROR,
    NO_PSSH_FOUND: NO_PSSH_FOUND_ERROR,
    AUTH_XML_REQUEST: AUTH_XML_REQUEST_ERROR,
    CERT_REQUEST: CERT_REQUEST_ERROR,
};
