/**
 * Base configurations
 * https://webdriver.io/docs/configurationfile.html
 */

// Environment configuration
const instances = parseInt(process.env.SELENIUM_MAXINSTANCES, 10);
const baseConfig = {
    maxInstances: isNaN(instances) ? 4 : instances,
    baseUrl:      process.env.PLAYER_BASEURL ? process.env.PLAYER_BASEURL : 'https://cvp-web.internal.justin.tv/master/test.html',
    specFileRetries: 0,
    logLevel: 'silent',
    bail: 0,
    waitforTimeout: 10000,
    connectionRetryTimeout: 90000,
    connectionRetryCount: 3,
    framework: 'mocha',
    reporters: ['spec', ['junit', {
        outputFileFormat(options) {
            return `results-${options.cid}.${options.capabilities.browserName}.xml`;
        },
        outputDir: './results',
        errorOptions: {
            error: 'message',
            failure: 'message',
            stacktrace: 'stack',
        },
    }]],

       // Hooks
       // =====
       // WebdriverIO provides a several hooks you can use to interfere the test process in order to enhance
       // it and build services around it. You can either apply a single function to it or an array of
       // methods. If one of them returns with a promise, WebdriverIO will wait until that promise got
       // resolved to continue.
       //
       /**
        * Gets executed before test execution begins. At this point you can access to all global
        * variables like browser. It is the perfect place to define custom commands.
        * @param {Array.<Object>} capabilities list of capabilities details
        * @param {Array.<String>} specs List of spec file paths that are to be run
        */

    before: () => {
        // tslint:disable-next-line: no-require-imports
        require('ts-node').register({ files: true });
        browser.url(browser.options.baseUrl);
    },
};

// Export configurations
module.exports = baseConfig;
