/**
 * CDP config only validates analytics test directory
 * https://webdriver.io/docs/configurationfile.html
 */

// tslint:disable-next-line:no-var-requires no-var-keyword no-require-imports
var base = require('./base.conf.ts');

exports.config = Object.assign({}, base, {
    runner: 'local',
    specFileRetries: 3,
    capabilities: [
        {
            'browserName': 'chrome',
            'specs': [
                './platforms/web/js/e2e/chrome-devtools-protocol/**/*.test.ts',
            ],
            'goog:chromeOptions': {
                args: [
                    'auto-open-devtools-for-tabs',
                ],
            },
        },
    ],
    services: ['selenium-standalone', 'devtools'],
    mochaOpts: {
        ui: 'bdd',
        /**
         * A single test should not take longer than the timeout.
         * Currently, buffering test take the longest at 240s
         */
        timeout: 240000,
        require: [
            'tsconfig-paths/register',
        ],
    },
});
