/**
 * CBG config excludes analytics test directory due to
 * CDP limitations.
 * https://webdriver.io/docs/configurationfile.html
 */

// tslint:disable-next-line:no-var-requires no-var-keyword no-require-imports
var base = require('./base.conf.ts');

const gridUser = process.env.GRID_USER ? process.env.GRID_USER : 'player-core';
const gridSecret = process.env.GRID_SECRET ? process.env.GRID_SECRET : '';
const gridHost = process.env.GRID_HOST ? process.env.GRID_HOST : 'cbg.internal.justin.tv';
console.log(`GRID: ${gridUser}@${gridHost}`);

exports.config = Object.assign({}, base, {
    hostname: `${gridUser}:${gridSecret}@${gridHost}`,
    protocol: 'https',
    port: 443,
    specFileRetries: 3,
    capabilities: [
        {
            browserName: 'chrome',
            specs: ['./platforms/web/js/e2e/specs/**/*.test.ts'],
        },
        {
            browserName: 'firefox',
            specs: ['./platforms/web/js/e2e/specs/**/*.test.ts'],
        },
    ],
    mochaOpts: {
        ui: 'bdd',
        /**
         * A single test should not take longer than the timeout.
         * Currently, id property test take the longest at ~300s
         */
        timeout: 300000,
        require: [
            'tsconfig-paths/register',
        ],
    },
});
