/**
 * Local config
 * https://webdriver.io/docs/configurationfile.html
 */

// tslint:disable-next-line:no-var-requires no-var-keyword no-require-imports
var base = require('./base.conf.ts');

exports.config = Object.assign({}, base, {
    runner: 'local',
    capabilities: [
        {
            'browserName': 'chrome',
            'specs': ['./platforms/web/js/e2e/**/*.test.ts'],
            'goog:chromeOptions': {
                args: [
                    'auto-open-devtools-for-tabs',
                ],
            },
        },
        {
            browserName: 'firefox',
            specs: ['./platforms/web/js/e2e/specs/**/*.test.ts'],
        },
    ],
    services: ['selenium-standalone', 'devtools'],
    mochaOpts: {
        ui: 'bdd',
        /**
         * A single test should not take longer than the timeout.
         * Currently, id property test take the longest at ~300s
         */
        timeout: 300000,
        require: [
            'tsconfig-paths/register',
        ],
    },
});
