import assert from 'assert';
import { Validator } from 'jsonschema';
import { PlayerState } from '../../event/state';
import { VIDEO_PLAY_SCHEMA } from '../schemas/video-play-schema';
import {
    checkPlayerState,
    load,
    pause,
    play,
    setAutoplay,
    setDeviceId,
    trackAnalyticEvent,
} from '../utils';

const LIVE_URL = process.env.PLAYER_LIVEURL ? process.env.PLAYER_LIVEURL : 'https://twitch.tv/bufferbunny';
const VOD_URL = process.env.PLAYER_VODURL ? process.env.PLAYER_VODURL : 'https://www.twitch.tv/videos/306892197';
console.log(`Live URL: ${LIVE_URL}`);
console.log(` VOD URL: ${VOD_URL}`);

const VIDEO_PLAY = 'video-play';
const N_SECOND_PLAY = 'n_second_play';
const MINUTE_WATCHED = 'minute-watched';

describe('ID-Properties', () => {
    function testPlaySessionId(url: string) {
        it(`should update play_session_id property on all events on new play session`, () => {
            setAutoplay(true);
            load(url);

            const firstVP = trackAnalyticEvent(VIDEO_PLAY);
            const firstMW = trackAnalyticEvent(MINUTE_WATCHED);
            assert.equal(firstVP['name'], VIDEO_PLAY);
            assert.equal(firstMW['name'], MINUTE_WATCHED);

            const firstPlaySessionId = firstVP['properties']['play_session_id'];
            assert.equal(firstMW['properties']['play_session_id'], firstPlaySessionId);

            load('');

            load(url);
            const secondVP = trackAnalyticEvent(VIDEO_PLAY);
            const secondMW = trackAnalyticEvent(MINUTE_WATCHED);
            assert.equal(secondVP['name'], VIDEO_PLAY);
            assert.equal(secondMW['name'], MINUTE_WATCHED);

            const secondPlaySessionId = secondVP['properties']['play_session_id'];
            assert.notEqual(firstPlaySessionId, secondPlaySessionId);
            assert.equal(secondMW['properties']['play_session_id'], secondPlaySessionId);
        });

    }
    testPlaySessionId(LIVE_URL);
    testPlaySessionId(VOD_URL);

    function testDeviceId(url: string) {
        it(`device_id property should match what is set with setDeviceId`, () => {
            const expectedDeviceId = 'a_device_id';
            setDeviceId(expectedDeviceId);
            setAutoplay(true);
            load(url);

            const videoPlay = trackAnalyticEvent(VIDEO_PLAY);
            const nSecondPlay = trackAnalyticEvent(N_SECOND_PLAY);
            assert.equal(videoPlay['name'], VIDEO_PLAY);
            assert.equal(nSecondPlay['name'], N_SECOND_PLAY);

            assert.equal(videoPlay['properties']['device_id'], expectedDeviceId);
            assert.equal(nSecondPlay['properties']['device_id'], expectedDeviceId);
        });
    }
    testDeviceId(LIVE_URL);
    testDeviceId(VOD_URL);
});
