import { Player } from '../player';
declare const player: Player;

/**
 * Load url for channel or vod using API player.load
 * @param url string
 */
export function load(url: string) {
    browser.execute(`player.load('${url}')`);
}

/**
 * API execution for setAutoplay
 * @param url string
 */
export function setAutoplay(autoplay: boolean = false) {
    browser.execute(`player.setAutoplay('${autoplay}')`);
}

/**
 * API execution for play
 */
export function play() {
    browser.execute('player.play()');
}

/**
 * API execution for pause
 */
export function pause() {
    browser.execute('player.pause()');
}

/**
 * API execution for seek
 * @param time in seconds for setting current time of player
 */
export function seekTo(time: number = 0) {
    browser.execute(`player.seekTo(${time})`);
}

/**
 * API execution for setDeviceId
 * @param id as a string
 */
export function setDeviceId(id: string = '') {
    browser.execute(`player.setDeviceId('${id}')`);
}

/**
 * @param event PlayerTracking event to listen and obtain
 * @returns {object} properties of the eventToTrack
 */
export function trackAnalyticEvent(event: string, timeout: number = 30000): object {
    try {
        browser.setTimeout({ script: timeout });
        // tslint:disable-next-line: no-shadowed-variable
        return browser.executeAsync((event: string, done) => {
            player.addEventListener('PlayerTracking', (state) => {
                if (state['name'] === event) {
                    done(state);
                }
            });
        }, event);
    } catch (e) {
        console.log(`Error: Failed to find Analytic ${event} in ${timeout} ms`);
        throw e;
    }
}

export function trackPlayerEvent(event: string, timeout: number = 30000) {
    try {
        browser.setTimeout({ script: timeout });
        // tslint:disable-next-line: no-shadowed-variable
        return browser.executeAsync((event: string, done) => {
            player.addEventListener(event, () => {
                done(true);
            });
        }, event);
    } catch (e) {
        console.log(`Error: Failed to find ${event} in ${timeout} ms`);
        throw e;
    }
}

export function checkPlayerState(state: string, timeout: number = 30000) {
    try {
        browser.setTimeout({ script: timeout });
        // tslint:disable-next-line: no-shadowed-variable
        return browser.executeAsync((state, done) => {
            if (player.getPlayerState() === state) {
                done(true);
            } else {
                player.addEventListener(state, () => {
                    done(true);
                });
            }
        }, state);
    } catch (e) {
        console.log(`Error: Failed to find ${state} in ${timeout} ms`);
        throw e;
    }
}

/**
 * Throttle internet connection with latency
 * @param conditions
 */
export function emulateNetworkWithLatency(conditions: object) {
    // @ts-ignore <https://gitter.im/webdriverio/webdriverio?at=5a830aa681cd9a5d7ea3f837>
    browser.cdp('Network', 'emulateNetworkConditions', conditions);
}

/**
 * Determine a value between lowerLimit and upperLimit
 * @param value Value to check
 * @param lowerLimit Lower limit
 * @param upperLimit Upper limit
 * @returns {boolean}
 */
export function between(value: number, lowerLimit: number, upperLimit: number): boolean {
    return value >= lowerLimit && value <= upperLimit;
}
