/**
 * The error names match the result names in result.hpp
 * These are not emitted as their own events, but instead
 * populate the 'type' property in the player.js 'ERROR' event.
 */
export enum ErrorType {
    /** Generic error occurred */
    GENERIC = 'Error',

    /** Method or feature not supported */
    NOT_SUPPORTED = 'ErrorNotSupported',

    /** No source present for the operation */
    NO_SOURCE = 'ErrorNoSource',

    /** Data or input is invalid for the operation */
    INVALID_DATA = 'ErrorInvalidData',

    /** Class or object is an invalid state */
    INVALID_STATE = 'ErrorInvalidState',

    /** Method parameter is invalid */
    INVALID_PARAMETER = 'ErrorInvalidParameter',

    /** Method or operation timed out */
    TIMEOUT = 'ErrorTimeout',

    /** Output is invalid for the operation */
    INVALID_OUTPUT = 'ErrorInvalidOutput',

    /** An unexpected internal error has occurred. */
    INTERNAL = 'ErrorInternal',

    /** Unspecified Network error */
    NETWORK = 'ErrorNetwork',

    /** Error indicating a network I/O failure */
    NETWORK_IO = 'ErrorNetworkIO',

    /** Error indicating a network resource is not authorized */
    AUTHORIZATION = 'ErrorAuthorization',

    /** Error indicating a network resource is not available */
    NOT_AVAILABLE = 'ErrorNotAvailable',

}

export enum AuthorizationError {
    /** Error indicating premium content is not avaliable in your region */
    GEOBLOCKED = 1,

    /** Error indicating device does not support playback of premium content */
    UNSUPPORTED_DEVICE,

    /** Error indicating a proxy or unblocker has been detected */
    ANONYMIZER_BLOCKED,

    /** Error indicating wi-fi network is needed to watch premium conntent */
    CELLULAR_NETWORK_PROHIBITED,

    /** Error indicating restricted premium content */
    UNAUTHORIZATION_ENTITLEMENTS,

    /** Error indicating restricted vod */
    VOD_RESTRICTED,
}
