/**
 * Publicly exposed timed-metadata events (listen with `addEventListener()`).
 * Fired based on the current position of the playhead.
 */
export enum MetadataEvent {
    /**
     * ID3 encountered. A direct json encoding of the id3 is provided
     * They follow this form: [{id: 'TRCK', info:[val1, val2, ...]}...]
     * @param {Object[]} id3 - List of ID3 keys and values
     */
    ID3 = 'MetaID3',
    /**
     * Caption update
     * @param {Object}{ caption info }
     */
    CAPTION = 'MetaCaption',
}
