/**
 * Public events sent from the MediaPlayer. These are listened to internally,
 * but can also be publicly consumed with `addEventListener` All events are
 * currently emitted from the WebMediaPlayer in the worker. The getters that
 * are updated with each event are listed below. The payloads are currently not
 * publicly exposed, but contain the internal state change information.
 */
export enum RemotePlayerEvent {
    AVAILABLE = 'RemotePlayerAvailable',
    UNAVAILABLE = 'RemotePlayerUnavailable',
    SESSION_STARTED = 'RemotePlayerSessionStarted',
    SESSION_ENDED = 'RemotePlayerSessionEnded',
}
