// Missing types and identifiers from webpack and newer browers
declare const VERSION: string;

declare interface VTTJS {
    restore: Function;
    VTTCue: VTTCue;
}

declare interface Window {
    // tslint:disable:no-any
    WebAssembly: any;
    WebKitMediaKeys: any;
    // tslint:enable:no-any
    ReadableStream: ReadableStream;
    XMLHttpRequest: XMLHttpRequest;
    VTTCue: VTTCue;
    vttjs: VTTJS;
}

declare interface Document {
    exitFullScreen: Function;
    webkitExitFullscreen: Function;
    mozCancelFullScreen: Function;
    msExitFullscreen: Function;
}

declare interface WebKitMediaKeySession {
    keySystem: string;
    close(): void;
    update(key: Uint8Array): void;
}
declare interface WebKitMediaKeyMessageEvent extends Event {
    message: Uint8Array;
}

declare interface WebKitMediaKeys {
    createSession(type: string, initData: ArrayBuffer);
}

declare interface HTMLVideoElement { // Safari specific
    webkitKeys: WebKitMediaKeys;
    webkitDecodedFrameCount: number;
    webkitDroppedFrameCount: number;
    mozDecodedFrames: number;
    webkitSetMediaKeys(mediakeys: WebKitMediaKeys): Function;
    webkitRequestFullscreen(): Function;
    mozRequestFullScreen(): Function;
    msRequestFullscreen(): Function;
}

interface MessageHander {
    onmessage: (ev: MessageEvent) => void | null;
    // tslint:disable-next-line:no-any
    postMessage(message: any, transfer?: Transferable[]);
}

declare interface Navigator {
    // tslint:disable-next-line:no-any
    mediaCapabilities: any;
}

declare interface Videojs {
    getTech: Function;
    extend: Function;
    registerTech: Function;
    getComponent: Function;
    registerComponent: Function;
    registerPlugin: Function;
    plugin: Function;
}
