// For a detailed explanation regarding each configuration property, visit:
// https://jestjs.io/docs/en/configuration.html

module.exports = {
  // Automatically clear mock calls and instances between every test
  clearMocks: true,

  // The directory where Jest should output its coverage files
  coverageDirectory: "coverage",

  // An array of file extensions your modules use
  moduleFileExtensions: [
    "js",
    "json",
    "jsx",
    "ts",
    "tsx",
    "node"
  ],

  // A list of paths to directories that Jest should ignore
  modulePathIgnorePatterns: [
    "<rootDir>/platforms/web/js/e2e"
  ],

  // Setting rootDir to project root
  rootDir: '../../..',

  // A list of paths to directories that Jest should use to search for files in
  roots: [
    "<rootDir>/platforms/web/js",
  ],

  // A map from regular expressions to paths to transformers
  transform: {
    "^.+\\.tsx?$": "ts-jest",
  },

  globals: {
    WASM_WORKER_URL: 'wasmworker.js',
    ASMJS_WORKER_URL: 'worker.js',
    WASM_BINARY_URL: 'wasmworker.wasm',
  },
};
