export interface MediaSink {
    configure(config: TrackConfig): void;
    enqueue(sample: MediaSample): void;
    endOfStream(): void;
    setTimestampOffset(update: PlaybackRateUpdate): void;
    play(): void;
    pause(): void;
    reinit(): void;
    remove(range: BufferRange): void;
    seekTo(playhead: number): void;
    setPlaybackRate(rate: number): void;
    setVolume(volume: number): void;
    getVolume(): number;
    addCue(start: number, end: number, onCue: (enter: boolean) => void): void;
    buffered(): BufferRange;
    decodedFrames(): number;
    droppedFrames(): number;
    framerate(): number;
    delete(): void;
    isMuted(): boolean;
    setMuted(muted: boolean): void;
    getDisplayWidth(): number;
    getDisplayHeight(): number;
    getPlaybackRate(): number;
    getCurrentTime(): number;
    bufferDuration(): number;
}

export interface MediaSinkListener {
    onSinkIdle(): void;
    onSinkStop(playFailed: boolean): void;
    onSinkDurationChanged(duration: number): void;
    onSinkEnded(): void;
    onSinkError(err: PlaybackError): void;
    onSinkBufferUpdate(): void;
    onSinkTimeUpdate(): void;
    onSinkPlay(): void;
    onSinkPlaying(forcePlay: boolean): void;
    onSinkVideoDisplaySizeChanged(w: number, h: number): void;

    // remote
    onRemoteDevice(available: boolean): void;
    onSessionError(): void;
    onLoadMediaError(): void;
    onUserCancel(): void;
    onSessionStop(): void;
    onSessionStarted(deviceName: string): void;
}

export type MediaSinkMode = 'mse' | 'passthrough' | 'chromecast';

export interface TrackConfig {
    trackID: number;
    codec: string;
    path: string;
    mode: MediaSinkMode;
    isProtected: boolean;
}

export interface MediaSample {
    trackID: number;
    buffer: ArrayBuffer;
}

export interface PlaybackRateUpdate {
    trackID: number;
    offset: number;
}

export interface PlaybackError {
    value: number;
    code: number;
    message: string;
}

export interface BufferRange {
    start: number;
    end: number;
}
