/**
 * Sent from the worker to perform operations on the main thread.
 * Since access to web apis is limited in a worker, we must proxy
 * all media rendering and local storage operations to the main thread.
 * These are all internal and should no be exposed publicly. All messages
 * have at most a single argument.
 */
export const enum ClientMessage {
    /**
     * The player state has changed
     * @param {Object} Player properties that have changes with this state transition
     */
    STATE_CHANGED,
    /**
     * Append an mp4 audio buffer to MSE
     * @param {Number} stats.videoFrameRate - fps in Hz
     * @param {Number} stats.broadcasterLatency - latency from broadcaster in ms
     * @param {Number} stats.transcoderLatency - latency from transcoder in ms
     * @param {[NetworkProfile]} stats.networkProfile - list of stats for segment downloads
     */
    STATS,
    /**
     * Add a track to the sink
     * @param {Number} track.trackID - used to identify track in 'enqueue'
     * @param {String} track.mimeType - mimeType for the track
     * @param {String} track.src - use this source directly (passthrough)
     */
    CONFIGURE,
    /**
     * Clear media and reset to initial state
     */
    RESET,
    /**
     * Add a timed metadata cue to the text track
     * @param {number} cue.time - time to fire the metadata event
     * @param {number} cue.duration - duration of the metadata event
     */
    ADD_CUE,
    /**
     * Get decoded information
     */
    GET_DECODE_INFO,
    /**
     * Peform an operation on the mediasink
     */
    MEDIA_SINK_RPC,
}
