// This queue will only "garbage collect"
// when it becomes empty.
export class Queue<T> {
    private buffer: Array<T>;
    private head: number;
    private tail: number;

    constructor() {
        this.buffer = [];
        this.head = 0;
        this.tail = 0;
    }

    push(item: T) {
        if (this.tail === this.buffer.length) {
            this.buffer.push(item);
        } else {
            this.buffer[this.tail] = item;
        }
        this.tail++;
    }

    pop(): T {
        const item = this.buffer[this.head];
        this.buffer[this.head] = null;
        this.head++;

        // If we're empty, we can reset our
        // offsets to the begining
        if (this.empty()) {
            this.head = 0;
            this.tail = 0;
        }

        return item;
    }

    size(): number {
        return this.tail - this.head;
    }

    empty(): boolean {
        // head can be greater if we've "popped" too many
        return this.head >= this.tail;
    }
}
