import { WebTask } from './web-scheduler';

/**
 * Schedule a callback using 'setTimeout' or 'setInterval'
 * @param  {WebTask} task - defined in 'web-scheduler.cpp'
 * @param  {number} timeout - ms to wait before running
 * @param  {bool} repeating - use 'setInterval' to call every 'timeout'
 */
export function scheduleTask(task: WebTask, timeout: number, repeating: boolean) {
    let deleted = false;

    const id = repeating ?
        self.setInterval(() => task.call(), timeout) :
        self.setTimeout(() => {
            task.call();
            if (!deleted) {
                task.delete();
                deleted = true;
            }
        }, timeout);

    // Set cancel token for C++ api.
    task.setCancel(() => {
        if (!deleted) {
            clearTimeout(id);
            task.delete();
            deleted = true;
        }
    });
}
