// tslint:disable:no-invalid-this
// tslint:disable:no-any
export function getFakeEventTarget() {
    return {
        listenerMap: {},
        addEventListener(eventType: string, listener: Function) {
            const listenerList = this.listenerMap[eventType] || [];
            this.listenerMap[eventType] = listenerList;
            listenerList.push(listener);
        },
        dispatchEvent(event: Event, data: any) {
            const listenerList = this.listenerMap[event.type] || [];
            for (const listener of listenerList) {
                listener({
                    target: this,
                    ... data,
                });
            }
        },
    };
}
