/**
 * This util adds mock implementations of video element apis, sourcebuffers or
 * texttrack for jsdom environment
 */

// tslint:disable:no-empty
// tslint:disable:no-invalid-this
// tslint:disable:no-any
class MockVTTCue {
    startTime: number;
    endTime: number;
    text: string;

    constructor(start: number, end: number, text: string) {
        this.startTime = start;
        this.endTime = end;
        this.text = text;
    }
}

class TextTrack {
    cues: Array<VTTCue>;
    constructor() {
        this.cues = [];
    }
    addCue(cue: VTTCue) {
        this.cues.push(cue);
    }
    removeCue(cue: VTTCue) {
    }
}

export class MockSourceBuffer {
    updating: boolean;
    private offset: number;
    private listener: Function;
    private bufferedRange: object;
    constructor(updating: boolean) {
        this.updating = updating;
    }
    appendBuffer(buf: ArrayBuffer) {
    }
    remove(start: number, end: number) {
    }

    addEventListener(event: string, callback: Function) {
        this.listener = callback;
    }

    fireUpdateEndListener() {
        this.updating = false;
        this.listener.call(undefined);
    }

    set timestampOffset(val: number) {
        this.offset = val;
    }

    get timestampOffset() {
        return this.offset;
    }

    set buffered(val: object) {
        this.bufferedRange = val;
    }

    get buffered() {
        return this.bufferedRange;
    }
}

export function addMissingTextTrackImplementation(videoElementConstructor: Function = HTMLVideoElement) {
    videoElementConstructor.prototype.addTextTrack = function() {
        if (!this.textTracks) {
            this.textTracks = [];
        }
        const newTrack = new TextTrack();
        this.textTracks.push(newTrack);
        return newTrack;
    };
}

export function addMissingVTTCueImplementation(context: any = self) {
    context.VTTCue = MockVTTCue;
}

export function addMissingVideoElementProperties(videoElementConstructor: Function = HTMLVideoElement) {
    videoElementConstructor.prototype.error = null;
    videoElementConstructor.prototype.setMediaKeys = jest.fn();
}

export function createMockSourceBuffer(updating: boolean) {
    return new MockSourceBuffer(updating);
}

export function createMockTimeRanges(buffer: MockSourceBuffer, length: number, startTime: number, endTime: number) {
    buffer.buffered = {
        length,
        start: jest.fn().mockReturnValue(startTime),
        end: jest.fn().mockReturnValue(endTime),
    };
}

export function fireUpdateEndListenerOnSourceBuffer(buffer: MockSourceBuffer) {
    buffer.fireUpdateEndListener();
}
