import { EventEmitter } from 'events';

export class TypedEventEmitter<T> {
    private emitter: EventEmitter;

    constructor() {
        this.emitter = new EventEmitter();
    }

    // tslint:disable-next-line:no-any
    on(eventName: T, listener: (...args: any[]) => void) {
        this.emitter.on(String(eventName), listener);
    }

    // tslint:disable-next-line:no-any
    removeListener(eventName: T, listener: (...args: any[]) => void) {
        this.emitter.removeListener(String(eventName), listener);
    }

    // tslint:disable-next-line:no-any
    emit(eventName: T, ...args: any[]) {
        this.emitter.emit(String(eventName), ...args);
    }
}
