const mockCurrentScript = {
    src: 'https://randomdomain.twitch.tv/this-tech.js',
};
Object.defineProperty(document, 'currentScript', {
    value: mockCurrentScript,
});

jest.mock('./mediaplayer', () => {
    return {
        ...jest.requireActual('./mediaplayer'),

        createWorker: jest.fn(),
    };
});

// tslint:disable-next-line:no-require-imports
import registerTech = require('./videojs-hls-tech');

function getVideoJSMock() {
    return {
        extend: jest.fn().mockReturnValue({}),
        getTech: jest.fn(),
        getComponent: jest.fn(),
        registerTech: jest.fn(),
        registerComponent: jest.fn(),
        registerPlugin: jest.fn(),
        plugin: jest.fn(),
    };
}

describe('Check for all extends and registrations', () => {
    test('Test for all extends and registrations', () => {
        const videojs = getVideoJSMock();
        const techOptions = {
            logLevel: 'debug',
        };

        const extendSpy = jest.spyOn(videojs, 'extend');
        const registerTechSpy = jest.spyOn(videojs, 'registerTech');
        const registerCompSpy = jest.spyOn(videojs, 'registerComponent');
        const registerPluginSpy = jest.spyOn(videojs, 'registerPlugin');

        // Testing registerTech
        registerTech(videojs, techOptions);

        expect(extendSpy.mock.calls.length).toEqual(3); // Extends Tech, MenuItem and MenuButton

        const handleToTech = extendSpy.mock.results[0].value;
        expect(registerTechSpy).toBeCalledWith('TwitchWhiteLabel', handleToTech);

        const handleToComponent = extendSpy.mock.results[2].value; // QualityMenuButton
        expect(registerCompSpy).toBeCalledWith('QualityMenuButton', handleToComponent);

        expect(registerPluginSpy.mock.calls.length).toEqual(24); // 24 calls to registerPlugin
    });
});
