export interface HttpResponse {
    getStatus(): number;
    getHeader(key: string): string;
    readBody(proxy: ReaderProxy, timeout: number): void;
}

export interface RequestProxy {
    response(response: HttpResponse): void;
    error(timeout: boolean): void;
    delete(): void;
}

export interface ReaderProxy {
    read(pointer: number, length: number): void;
    end(): void;
    error(timeout: boolean): void;
    delete(): void;
}
