import { MediaSinkMode } from './mediasink';
import { Player } from './player';

// Emscripten
export interface EmscriptenModule {
    HEAPU8: Uint8Array;
    WebMediaPlayer: WebMediaPlayer;
    _free(pointer: number): void;
    _malloc(bytes: number): number;
    runTests(proxy: WebMediaPlayerProxy): void;
    // tslint:disable-next-line:no-any
    ccall(name: string, returnType: string, paramTypes: Array<string>, params: Array<any>): void;
}

// web-mediaplayer.cpp
export interface WebMediaPlayer extends Player {
    // tslint:disable-next-line:no-any
    new(proxy: WebMediaPlayerProxy, config: any, browserContext: BrowserContext): WebMediaPlayer;
    removeQuality(quality: Quality): void;
    getStats(): object;
    onClientDurationChanged(duration: number): void;
    onClientSinkUpdate(update: SinkUpdate): void;
    onClientSinkIdle(): void;
    onClientSinkPlaying(): void;
    onClientSinkEnded(): void;
    onClientSinkError(value: number, code: number, message: string): void;
    onClientSinkCue(id: number, enter: boolean);
}

export interface WebMediaPlayerProxy {
    // called from web-mediaplayer.cpp
    onDurationChanged(seconds: number): void;
    onMetadata(type: string, data: Uint8Array);
    onError(result: string, code: number, source: string, message: string): void;
    onSessionData(properties: SessionData);
    onQualityChanged(quality: Quality): void;
    onRebuffering(): void;
    onSeekCompleted(): void;
    onStateChanged(stateUpdats: object): void;
    onAnalyticsEvent(name: string, properties: string): void;
    onMasterPlaylistRequest(): void;
    onMediaPlaylistRequest(): void;
    onMasterPlaylistReady(): void;
    onMediaPlaylistReady(): void;
    // called from web-mediasink.cpp
    configure(trackID: number, codec: string, path: string, mode: MediaSinkMode, isProtected: boolean): void;
    endOfStream(): void;
    setTimestampOffset(trackID: number, offset: number);
    sendStats(): void;
    play(): void;
    pause(): void;
    reset(): void;
    remove(start: number, end: number): void;
    seekTo(time: number): void;
    setPlaybackRate(rate: number): void;
    enqueue(trackID: number, heapView: Uint8Array): void;
    reinit(): void;
    addCue(id: number, start: number, end: number): void;
    // called from both
    onJSONMetadata(metaJson: string): void;
}

export interface Quality {
    name: string;
    group: string;
    codecs: string;
    bitrate: number;
    width: number;
    height: number;
    framerate: number;
    isDefault: boolean;
}

export interface SinkUpdate {
    currentTime: number;
    framerate: number;
    droppedFrames: number;
    decodedFrames: number;
}

export type SessionData = Record<string, string>;

export interface BrowserContext {
    chrome: boolean;
    chromecast: boolean;
    domain: string;
    family: string;
    firefox: boolean;
    host: string;
    major: number;
    minor: number;
    msedge: boolean;
    msie: boolean;
    name: string;
    opera: boolean;
    osName: string;
    osVersion: string;
    patch: number;
    safari: boolean;
    url: string;
    userAgent: string;
}

export interface MessageHandler {
    onmessage: (ev: MessageEvent) => void | null;
    // tslint:disable-next-line:no-any
    postMessage(message: any, transfer?: Transferable[]);
}
