export {};

declare const self: DedicatedWorkerGlobalScope;

/**
 * Global polyfill applied to worker files
 */
polyfillPerformance(self);

/**
 * Polyfilled version of the 'peformance' web api,
 * using native functiontions when available.
 */
function polyfillPerformance(g: DedicatedWorkerGlobalScope) {
    if (!('performance' in g)) {
        // tslint:disable-next-line:no-any
        (g as any).performance = {};
    }

    if (!('now' in g.performance)) {
        // Use polyfill if performance or 'now' not available,
        // which is that case in Workers on non Chrome/Firefox.
        // We only polyfill the 'now' function, since that's all we use.
        const offset = Date.now();
        // tslint:disable-next-line:no-any
        (g.performance as any) = {
            now: () => {
                return Date.now() - offset;
            },
        };
    }
}
