#pragma once
#include "media/mp4/fmp4.hpp"
#include "playercore/MediaSample.hpp"

namespace twitch {

class Packager {
public:
    virtual ~Packager() = default;

    /**
     * Process a media sample. By default, we just pass it through
     */
    virtual void addSample(const MediaSampleBuffer& sample);

    /**
     * Render all sample to the buffer. This is only needed for
     * GoPs video packager when we know we'll not receive another
     * keyframe (switching qualities, end of stream)
     */
    virtual void render() {};

    /**
     * Access current buffered mp4. The buffer is written to in 'render'
     */
    const std::vector<uint8_t>& buffer() const;

    /**
     * Clear the current buffer.
     */
    void clear();

protected:
    std::vector<uint8_t> m_buffer;
};

class AudioPackager : public Packager {
public:
    AudioPackager(const std::vector<uint8_t>& extradata);
    void addSample(const MediaSampleBuffer& sample) override;

private:
    media::fmp4 m_mp4;
    std::shared_ptr<media::fmp4track_aac> m_track;
};

/**
 * Packages mp4 "frame by frame"
 */
class VideoPackager : public Packager {
public:
    VideoPackager(const std::vector<uint8_t>& extradata);
    void addSample(const MediaSampleBuffer& sample) override;

protected:
    void processSample(const MediaSampleBuffer& sample);
    void render() override;

    media::fmp4 m_mp4;
    std::shared_ptr<media::fmp4track_avc> m_track;
};

/**
 * Packages mp4 in full "GoPs"
 */
class VideoGopsPackager : public VideoPackager {
public:
    VideoGopsPackager(const std::vector<uint8_t>& extradata);
    void addSample(const MediaSampleBuffer& sample) override;
};

} // namespace twitch
