#include "msereaderfactory.hpp"
#include "media/mp2t/Mp2TReader.hpp"
#include "media/FragmentReader.hpp"

namespace twitch {
std::unique_ptr<media::MediaReader> MSEMediaReaderFactory::createReader(Platform& platform,
    media::MediaReader::Listener& listener,
    const MediaType& type, media::MediaReader::TrackId track, const std::string& url)
{
    using namespace twitch::media;
    std::unique_ptr<MediaReader> reader;

    if (type.matches(MediaType::Video_MP2T)) {
        // Transport Stream transmuxed to MP4 with the web sink
        reader.reset(new Mp2TReader(platform, listener, url));
    } else if (type.matches(MediaType::Video_MP4)) {
        // passthrough Fragmented MP4
        reader.reset(new FragmentReader(platform, listener, type, track, url));
    }
    return reader;
}
}
