#include "web-mediaplayer.hpp"
#include "web-platform.hpp"
#include <emscripten/bind.h>
#include <emscripten/emscripten.h>

using namespace emscripten;
using namespace twitch;
EMSCRIPTEN_BINDINGS(WebMediaPlayer)
{
    class_<MediaPlayer>("MediaPlayer")
        .function("load", select_overload<void(const std::string&, const std::string&)>(&MediaPlayer::load))
        .function("play", &MediaPlayer::play)
        .function("pause", &MediaPlayer::pause)
        .function("seekTo", select_overload<void(MediaPlayer&, double)>([](MediaPlayer& self, double time) { self.seekTo(MediaTime(time)); }))
        .function("setLooping", &MediaPlayer::setLooping)
        .function("setQuality", select_overload<void(const Quality&, bool)>(&MediaPlayer::setQuality))
        .function("removeQuality", &MediaPlayer::removeQuality)
        .function("setAuthToken", &MediaPlayer::setAuthToken)
        .function("setAutoSwitchQuality", &MediaPlayer::setAutoSwitchQuality)
        .function("setAutoInitialBitrate", &MediaPlayer::setAutoInitialBitrate)
        .function("setAutoMaxBitrate", &MediaPlayer::setAutoMaxBitrate)
        .function("setAutoMaxVideoSize", &MediaPlayer::setAutoMaxVideoSize)
        .function("setAutoViewportSize", &MediaPlayer::setAutoViewportSize)
        .function("setAutoViewportScale", &MediaPlayer::setAutoViewportScale)
        .function("setVolume", &MediaPlayer::setVolume)
        .function("setMuted", &MediaPlayer::setMuted)
        .function("setPlaybackRate", &MediaPlayer::setPlaybackRate)
        .function("setLiveMaxLatency", &MediaPlayer::setLiveMaxLatency)
        .function("setLiveLowLatencyEnabled", &MediaPlayer::setLiveLowLatencyEnabled)
        .function("setMinBuffer", select_overload<void(MediaPlayer&, double)>([](MediaPlayer& self, double time) { self.setMinBuffer(MediaTime(time)); }))
        .function("setMaxBuffer", select_overload<void(MediaPlayer&, double)>([](MediaPlayer& self, double time) { self.setMaxBuffer(MediaTime(time)); }))
        .function("setAnalyticsEndpoint", &MediaPlayer::setAnalyticsEndpoint)
        .function("setAnalyticsSendEvents", &MediaPlayer::setAnalyticsSendEvents)
        .function("setVisible", &MediaPlayer::setVisible)
        .function("setClientId", &MediaPlayer::setClientId)
        .function("setDeviceId", &MediaPlayer::setDeviceId)
        .function("setLiveSpeedUpRate", &MediaPlayer::setLiveSpeedUpRate)
        .function("setPlayerType", &MediaPlayer::setPlayerType)
        .function("startRemotePlayback", &MediaPlayer::startRemotePlayback)
        .function("endRemotePlayback", &MediaPlayer::endRemotePlayback);

    class_<WebMediaPlayer, base<MediaPlayer>>("WebMediaPlayer")
        .constructor<emscripten::val, emscripten::val, BrowserContext>()
        .function("getStats", &WebMediaPlayer::getStats) // Needed to send stats from web-mediasink
        .function("onClientSinkDurationChanged", &WebMediaPlayer::onClientSinkDurationChanged)
        .function("onClientSinkUpdate", &WebMediaPlayer::onClientSinkUpdate)
        .function("onClientSinkIdle", &WebMediaPlayer::onClientSinkIdle)
        .function("onClientSinkPlaying", &WebMediaPlayer::onClientSinkPlaying)
        .function("onClientSinkEnded", &WebMediaPlayer::onClientSinkEnded)
        .function("onClientSinkError", &WebMediaPlayer::onClientSinkError)
        .function("onClientSinkCue", &WebMediaPlayer::onClientSinkCue)
        .function("onMediaDecodingInfoResult", &WebMediaPlayer::onMediaDecodingInfoResult);

    value_object<Quality>("Quality")
        .field("name", &Quality::name)
        .field("group", &Quality::group)
        .field("codecs", &Quality::codecs)
        .field("bitrate", &Quality::bitrate)
        .field("width", &Quality::width)
        .field("height", &Quality::height)
        .field("framerate", &Quality::framerate)
        .field("isDefault", &Quality::isDefault);

    value_object<BrowserContext>("BrowserContext")
        .field("chrome", &BrowserContext::isChrome)
        .field("chromecast", &BrowserContext::isChromecast)
        .field("domain", &BrowserContext::domain)
        .field("family", &BrowserContext::family)
        .field("firefox", &BrowserContext::isFirefox)
        .field("host", &BrowserContext::host)
        .field("major", &BrowserContext::major)
        .field("minor", &BrowserContext::minor)
        .field("msedge", &BrowserContext::isMsedge)
        .field("msie", &BrowserContext::isMsie)
        .field("name", &BrowserContext::name)
        .field("osName", &BrowserContext::osName)
        .field("osVersion", &BrowserContext::osVersion)
        .field("patch", &BrowserContext::patch)
        .field("safari", &BrowserContext::isSafari)
        .field("url", &BrowserContext::url)
        .field("userAgent", &BrowserContext::userAgent);

    value_object<MediaCapabilitiesInfo>("MediaCapabilitiesInfo")
        .field("smooth", &MediaCapabilitiesInfo::smooth)
        .field("supported", &MediaCapabilitiesInfo::supported)
        .field("powerEfficient", &MediaCapabilitiesInfo::powerEfficient);

    value_object<MediaConfig>("MediaConfig")
        .field("type", &MediaConfig::type)
        .field("video", &MediaConfig::video);

    value_object<VideoConfig>("VideoConfig")
        .field("contentType", &VideoConfig::contentType)
        .field("bitrate", &VideoConfig::bitrate)
        .field("framerate", &VideoConfig::framerate)
        .field("width", &VideoConfig::width)
        .field("height", &VideoConfig::height);
}
