#pragma once
#include "playercore/Log.hpp"
#include <emscripten/emscripten.h>

namespace twitch {

class WebLog : public Log {
public:
    WebLog(const std::string& level)
        : m_level(Log::levelFromString(level))
    {
    }

    void log(Level level, const char* format, va_list args) const override
    {
        if (level >= m_level) {
            int emLevel;

            switch (level) {
            case Level::Debug:
                emLevel = EM_LOG_CONSOLE;
                break;

            case Level::Info:
                emLevel = EM_LOG_CONSOLE;
                break;

            case Level::Warning:
                emLevel = EM_LOG_WARN;
                break;

            case Level::Error:
                emLevel = EM_LOG_ERROR;
                break;
            }

            // format the string since emscripten_log can't take a va_list
            const int LogMaxLength = 1024;
            char str[LogMaxLength];
            std::vsnprintf(str, LogMaxLength, format, args);
            emscripten_log(emLevel, "%s", str);
        }
    }
    void setLevel(Level level) override { m_level = level; }

private:
    Level m_level;
};
}
