#pragma once

#include "player/MediaPlayer.hpp"
#include "web-mediasink.hpp"
#include "web-platform.hpp"
#include <emscripten/emscripten.h>

namespace twitch {
class WebMediaPlayer : public MediaPlayer, public Player::Listener {
public:
    WebMediaPlayer(const emscripten::val& proxy, const emscripten::val& config, const BrowserContext& browserContext);
    // Player callbacks
    void onDurationChanged(MediaTime duration) override;
    void onError(const Error& error) override;
    void onMetadata(const std::string& type, const std::vector<uint8_t>& data) override;
    void onQualityChanged(const Quality& quality) override;
    void onRebuffering() override;
    void onRecoverableError(const Error& error) override;
    void onSeekCompleted(MediaTime time) override;
    void onSessionData(const std::map<std::string, std::string>& properties) override;
    void onStateChanged(Player::State state) override;
    void onAnalyticsEvent(const std::string& name, const std::string& properties) override;
    void onPositionChanged(MediaTime position) override;

    void onRequestSent(const MediaSource::Request& request) override;
    void onResponseReceived(const MediaSource::Request& request) override;
    void onResponseBytes(const MediaSource::Request& request, size_t bytes) override;
    void onResponseEnd(const MediaSource::Request& request) override;
    void onRequestError(const MediaSource::Request& request, int error) override;

    // MediaSink callbacks
    void onClientSinkDurationChanged(double time);
    void onClientSinkUpdate(const emscripten::val& update);
    void onClientSinkIdle();
    void onClientSinkPlaying();
    void onClientSinkEnded();
    void onClientSinkError(int value, int code, const std::string& message);
    void onClientSinkCue(int id, bool enter);


    void onMediaDecodingInfoResult(const MediaCapabilitiesInfo& info);
    void getDecodingInfo(const MediaConfig& config);
    emscripten::val getStats() const;
    void setListener(Player::Listener* listener);

private:
    emscripten::val stateUpdate(MediaPlayer::State playerState) const;
    emscripten::val getQualitiesArray() const;
    WebMediaSink& getSink() const;

    emscripten::val m_proxy;
    std::map<std::string, std::string> m_sessionData;
    Player::Listener* m_listener;
};
}
