#pragma once
#include "playercore/platform/Platform.hpp"
#include "msereaderfactory.hpp"
#include <emscripten/val.h>

namespace twitch {
struct MediaCapabilitiesInfo {
    bool smooth;
    bool supported;
    bool powerEfficient;
};

struct VideoConfig {
    std::string contentType;
    int width;
    int height;
    int bitrate;
    int framerate;
};

struct MediaConfig {
    std::string type;
    VideoConfig video;
};

struct BrowserContext {
    bool isChrome;
    bool isChromecast;
    bool isFirefox;
    bool isMsedge;
    bool isMsie;
    bool isSafari;
    int major;
    int minor;
    int patch;
    std::string deviceId;
    std::string domain;
    std::string family;
    std::string host;
    std::string name;
    std::string osName;
    std::string osVersion;
    std::string url;
    std::string userAgent;
};

class WebMediaSink;

class WebPlatform : public Platform {
public:
    WebPlatform(const emscripten::val& proxy, const emscripten::val& config, const BrowserContext& browserContext);
    virtual ~WebPlatform() = default;

    std::shared_ptr<Scheduler> createScheduler(const std::string& name) override;
    std::unique_ptr<MediaSink> createSink(MediaSink::Listener& listener, std::shared_ptr<Scheduler>) override;
    std::unique_ptr<MediaSource> createSource(const std::string&, const MediaType&, MediaSource::Listener&, std::shared_ptr<Scheduler>) override;
    std::shared_ptr<HttpClient> createAsyncHttpClient(std::shared_ptr<Scheduler> scheduler) override;
    std::shared_ptr<Log> getLog() const override;
    std::shared_ptr<HttpClient> getHttpClient() const override;
    std::shared_ptr<MediaReaderFactory> getMediaReaderFactory() const override;
    VideoDecoderCapabilities getVideoDecoderCapabilities(const MediaType& mediaType) override;
    const std::string& getName() const override;
    const Capabilities& getCapabilities() const override;
    const std::set<MediaType>& getSupportedMediaTypes() const override;
    const std::set<std::vector<uint8_t>>& getSupportedProtectionSystems() const override;
    const std::map<std::string, std::string>& getAnalyticsProperties() override;

private:
    emscripten::val m_proxy;
    std::shared_ptr<Log> m_webLog;
    std::shared_ptr<HttpClient> m_webHTTP;
    std::shared_ptr<MediaReaderFactory> m_readerFactory;
    std::set<MediaType> m_supported;
    std::set<std::vector<uint8_t>> m_protectionSystems;
    bool m_mseSupported;
    Capabilities m_capabilities;
    std::map<std::string, std::string> m_analyticsProperties;
};
}
