#include "playercore/platform/Scheduler.hpp"
#include <memory>
#include <vector>

namespace twitch {
class WebTask;

class WebScheduler : public Scheduler {
public:
    WebScheduler() = default;
    virtual ~WebScheduler();
    std::shared_ptr<Cancellable> schedule(Action action, Scheduler::Microseconds time, bool repeating) override;
    void scheduleAndWait(Action action) override;

private:
    std::vector<std::weak_ptr<WebTask>> m_scheduled;
};
}
