#pragma once

#include "AudioSample.hpp"
#include "MediaFoundation.hpp"
#include "playercore/MediaDecoder.hpp"
#include "CoInitialize.hpp"

namespace twitch {
namespace windows {

    class AudioDecoder : public MediaFoundation, public CCoInitialize, public MediaDecoder {
    public:
        enum ProcessType {
            Default = 0,
            Discard = 1,
        };

        AudioDecoder();
        AudioDecoder(const AudioDecoder& rhs) = delete;
        AudioDecoder& operator=(const AudioDecoder& rhs) = delete;

        MediaResult configure(const MediaFormat& input, MediaFormat& output) override;
        MediaResult decode(const twitch::MediaSampleBuffer& input) override;
        MediaResult hasOutput(bool& hasOutput) override;
        MediaResult getOutput(std::shared_ptr<twitch::MediaSample>& output) override;
        MediaResult flush() override;
        MediaResult reset() override;

    protected:
    private:
        void associateOutput(IMFSample* sample);
        MediaResult processInput(const twitch::MediaSampleBuffer& input);
        MediaResult processOutput(HRESULT& hr, ProcessType pt = ProcessType::Default);

        void handleOutputDataBuffer(MFT_OUTPUT_DATA_BUFFER& outputDataBuffer, ProcessType pt);
        void deriveOutputFromInput(const MediaFormat& input, MediaFormat& output);

        // AAC Decoder
        Microsoft::WRL::ComPtr<IMFTransform> m_decoderTransform;

        int m_bitsPerSample = 0;
        int m_samplesPerSecond = 0;
        unsigned char m_numChannels = 0;
        unsigned char m_internalNumChannels = 0;
        int m_internalBitsPerSample = 0;

        std::list<std::shared_ptr<AudioSample>> m_outputSamples;
    };
}
}
