#pragma once

#include "playercore/MediaRenderer.hpp"

namespace twitch {
namespace windows {

	class Transform;

	class AudioRenderer : public twitch::AudioRenderer {
	public:
		static std::unique_ptr<AudioRenderer> create();
		virtual ~AudioRenderer();

		MediaResult configure(const MediaFormat& format) override;
		MediaResult render(std::shared_ptr<const twitch::MediaSample> input) override;
		MediaResult getRenderedPresentationTime(MediaTime& time) override;

		MediaResult start() override;
		MediaResult stop() override;
		MediaResult flush() override;

		MediaResult setPlaybackRate(float rate) override;
		MediaResult setVolume(float volume) override;

	private:
		enum class State { Initial, Ready };

		Microsoft::WRL::ComPtr<IMFMediaSink> m_mediaSink;
		Microsoft::WRL::ComPtr<IMFPresentationClock> m_presentationClock;
		Microsoft::WRL::ComPtr<IMFSinkWriter> m_writer;
		std::unique_ptr<Transform> m_transform;
		float m_slowestRate;
		float m_fastestRate;
		float m_playbackRate = 1.0f;
		float m_volume = 1.0f;
		State m_state = State::Initial;
		unsigned m_nChannels = 0;
		unsigned m_samplesPerSecond = 0;
		unsigned m_bitsPerSample = 0;

		AudioRenderer(HRESULT& hr);
		HRESULT Configure(bool isForced);
		HRESULT Render(LONGLONG time, LONGLONG duration, std::vector<uint8_t> const& data);
		HRESULT SetPlaybackRate(float playbackRate);
		HRESULT SetVolume(float volume);
		HRESULT GetTime(MFTIME& time);
		HRESULT InternalSetVolume();
	};

}
}
