#include "pch.h"
#include "CoInitialize.hpp"

namespace twitch {
namespace windows {

CCoInitialize::CCoInitialize()
#ifdef __cplusplus_winrt
    : m_hr(CoInitializeEx(NULL, COINIT_APARTMENTTHREADED))
#else
    : m_hr(CoInitializeEx(NULL, COINIT_MULTITHREADED))
#endif
{
#ifdef __cplusplus_winrt
    assert(m_hr);
#else
    assert(SUCCEEDED(m_hr));
#endif
}

CCoInitialize::~CCoInitialize()
{
    if (SUCCEEDED(m_hr)) {
        CoUninitialize();
    }
}

}
}
